//===========================================================================================
// WormHole FleshFragment, the result of something small or frail going through a wormhole...
//===========================================================================================
class WormHoleGiblet expands DeusExFragment;

#exec TEXTURE IMPORT NAME="WHGiblet" FILE="C:\DeusEx\MSTNM\Textures\WHGiblet.pcx" GROUP=Skins

auto state Flying
{
	function BeginState()
	{
		Super.BeginState();

		Velocity = VRand() * 300;
		DrawScale = FRand() + 1.5;
	}
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);
	
	if (!IsInState('Dying'))
		if (FRand() < 0.5)
			Spawn(class'WHBloodDrop',,, Location);
}

defaultproperties
{
     Fragments(0)=LodMesh'DeusExItems.FleshFragment1'
     Fragments(1)=LodMesh'DeusExItems.FleshFragment2'
     Fragments(2)=LodMesh'DeusExItems.FleshFragment3'
     Fragments(3)=LodMesh'DeusExItems.FleshFragment4'
     numFragmentTypes=4
     elasticity=0.400000
     ImpactSound=Sound'DeusExSounds.Generic.FleshHit1'
     MiscSound=Sound'DeusExSounds.Generic.FleshHit2'
     Mesh=LodMesh'DeusExItems.FleshFragment1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     Mass=5.000000
     Buoyancy=5.500000
     bVisionImportant=True
     MultiSkins(0)=Texture'WHGiblet'
     MultiSkins(1)=Texture'WHGiblet'
     MultiSkins(2)=Texture'WHGiblet'
     MultiSkins(3)=Texture'WHGiblet'
     MultiSkins(4)=Texture'WHGiblet'
     MultiSkins(5)=Texture'WHGiblet'
     MultiSkins(6)=Texture'WHGiblet'
     MultiSkins(7)=Texture'WHGiblet'
}
